using System;
using Server;
using Server.Items;
using Server.Network;
using Server.Mobiles;
using Server.Targeting;

namespace Server.Gumps
{
	public class MonsterContractGump : Gump
	{
		private MonsterContract MCparent;
		
		public MonsterContractGump( Mobile from, MonsterContract parentMC ) : base( 0, 0 )
		{
			this.Closable=true;
			this.Disposable=true;
			this.Dragable=true;
			this.Resizable=false;

			this.AddPage(0);
			this.AddBackground(0, 0, 300, 170, 5170);
			this.AddLabel(40, 40, 0, @"Lovecka zakazka na: " + parentMC.AmountToKill + " " + parentMC.Monster);
			this.AddLabel(40, 60, 0, @"Pocet ulovenych: " + parentMC.AmountKilled);
			this.AddLabel(40, 80, 0, @"Odmena: " + parentMC.Reward);
			if ( parentMC.AmountKilled == 0 )
			{
				this.AddButton( 40, 110, 2061, 2061, 3, GumpButtonType.Reply, 0);
				this.AddLabel(54, 108, 0, @"Zrusit");
			}
			if ( parentMC.AmountKilled != parentMC.AmountToKill )
			{
				this.AddButton(150, 110, 2062, 2062, 1, GumpButtonType.Reply, 0);
				this.AddLabel(164, 108, 0, @"Pridat");
				//	this.AddButton(145, 110, 2061, 2062, 3, GumpButtonType.Reply, 0);
				//	this.AddLabel(159, 108, 0, @"Cancel Contract");
			}
			else
			{
				this.AddButton(40, 110, 2061, 2061, 2, GumpButtonType.Reply, 0);
				this.AddLabel(54, 108, 0, @"Vzit odmenu");
			}

			MCparent = parentMC;
		}
		
		public override void OnResponse( NetState state, RelayInfo info )
		{
			Mobile m_from = state.Mobile;
			
			if ( MCparent == null || MCparent.Deleted )
			   return;
			
			if ( info.ButtonID == 1 )
			{
				m_from.SendMessage("Vyber mrtvolu kterou chces pridat.");
				m_from.Target = new MonsterCorpseTarget( MCparent );
			}
			if ( info.ButtonID == 2 )
			{
				MCparent.Delete();
				m_from.SendMessage("Odmena byla umistena do tve banky!");
				m_from.BankBox.DropItem( new BankCheck( MCparent.Reward ) );
			}
			if ( info.ButtonID == 3 )
			{
				MCparent.Delete();
				m_from.SendMessage("Zakazka byla zrusena.");
				// 				m_from.AddToBackpack( new Gold(50) );
			}
		}
		
		private class MonsterCorpseTarget : Target
		{
			private MonsterContract MCparent;
			
			public MonsterCorpseTarget( MonsterContract parentMC ) : base( -1, true, TargetFlags.None )
			{
				MCparent = parentMC;
			}
			
			protected override void OnTarget( Mobile from, object o )
			{
				if ( o is Corpse )
				{
					Corpse MCcorpse = (Corpse)o;
					
					if ( MCparent == null || MCparent.Deleted || MCcorpse == null || ((Item)MCcorpse).Deleted )
					{
						from.SendMessage("Kontrakt nenalezen!");
						return;
					}
					else if ( MCcorpse.Channeled )
					{
						from.SendMessage("Zneuctena mrtvola nemuze byt pridana do zakazky!");
						return;
					}
					else if ( MCparent.AmountKilled >= MCparent.AmountToKill )
					{
						from.SendMessage("Kontrakt je splnen!");
						return;
					}
					if ( MCcorpse.CanLoot( from )/*MCcorpse.Killer == from*/ )
					{
						string m_type = "a " + MCparent.Monster;
						m_type = m_type.ToLower();
						string m_type2 = "an " + MCparent.Monster;
						m_type2 = m_type2.ToLower();
						
						if ( MCcorpse.Owner == null )
                  {
						   from.SendMessage("Tuto mrtvolu nelze pridat do zakazky!");
						   return;
                  }
                  
						string m_corpse = MCcorpse.Owner.Name;
						m_corpse = m_corpse.ToLower();
						
						if ( m_type == m_corpse || m_type2 == m_corpse )
						{
							MCparent.AmountKilled += 1;
							MCcorpse.Delete();
						}
						else
							from.SendMessage("Nespravny typ mrtvoly!");
					}
					else
						from.SendMessage("Nemuzes sebrat praci nekoho jineho pro sebe!");
				}
				else
					from.SendMessage("Toto neni mrtvola");
			}
		}
	}
}
